using UnityEngine;
using System.Collections;

public class s_LevelSelectButton : MonoBehaviour
{
	public Texture2D gotStartTexture;
	
	int level;
	
	public void Start()
	{
		level = s_LevelSelect.buttonCount++;
		
		//Set golden flys
		if (PlayerPrefs.GetInt("Stars " + level) != s_LevelSelect.invalidLevel)
			for (int i = 0; i < PlayerPrefs.GetInt("Stars " + level); ++i)
				transform.parent.transform.Find("Star" + (i+1)).renderer.material.mainTexture = gotStartTexture;
		
		//Set level number
		transform.parent.transform.Find("LevelNumber").GetComponent<TextMesh>().text = (level+1).ToString();
	}
	
	public bool Clicked()
	{	
		//If you have 0 or is the first level, don't go
		if (PlayerPrefs.GetInt("Stars " + (level - 1)) == s_LevelSelect.invalidLevel && level != 0)
		{
			AudioManager.PlaySound(AudioManager.buttonCant);
			return false;
		}
		else
		{
			transform.parent.renderer.material.color = new Color(0.5f, 0.75f, 0.75f);
			StartCoroutine(LoadLevel());
			return true;
		}
	}
	
	IEnumerator LoadLevel()
	{
		AudioManager.PlaySound(AudioManager.buttonYes);
		yield return new WaitForSeconds(AudioManager.buttonYes.length);
		Application.LoadLevel(level + s_LevelSelect.levelOffset);	
	}
}
